<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit;
}

// SMTP Configuration
$smtpServer = "mail.spacemail.com";
$smtpPort = 465;
$smtpUsername = "sales@starlightsolarllc.com";
$smtpPassword = "Stlight#98201";
$toEmail = "sales@starlightsolarllc.com";

// Get form data
$input = json_decode(file_get_contents("php://input"), true);

if (!$input) {
    echo json_encode(["status" => "error", "message" => "Invalid input"]);
    exit;
}

$type = $input['type'] ?? 'contact'; // 'contact' or 'quote'
$subject = $input['subject'] ?? "New Inquiry from Starlight Solar";
$name = filter_var($input['name'] ?? '', FILTER_SANITIZE_STRING);
$email = filter_var($input['email'] ?? '', FILTER_SANITIZE_EMAIL);

// Prepare HTML Content
$htmlContent = "
<html>
<head>
    <style>
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0; }
        .container { max-width: 600px; margin: 20px auto; background: #fff; border: 1px solid #eee; border-radius: 15px; overflow: hidden; box-shadow: 0 4px 15px rgba(0,0,0,0.05); }
        .header { background: #0a192f; color: #fff; padding: 40px; text-align: center; }
        .header h1 { margin: 0; font-size: 24px; letter-spacing: 2px; }
        .content { padding: 40px; }
        .field { margin-bottom: 20px; border-bottom: 1px solid #f9f9f9; padding-bottom: 15px; }
        .label { font-weight: bold; color: #007bff; display: block; font-size: 12px; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 5px; }
        .value { font-size: 16px; color: #444; }
        .footer { background: #f8f9fa; color: #666; padding: 30px; text-align: center; font-size: 13px; border-top: 1px solid #eee; }
        .footer a { color: #007bff; text-decoration: none; margin: 0 10px; }
        .tag { display: inline-block; padding: 4px 12px; border-radius: 20px; background: #e7f3ff; color: #007bff; font-weight: bold; font-size: 11px; margin-bottom: 20px; }
    </style>
</head>
<body>
    <div class='container'>
        <div class='header'>
            <h1>STARLIGHT SOLAR</h1>
            <p style='color: rgba(255,255,255,0.6); font-size: 14px; margin-top: 5px;'>Premium Energy Solutions</p>
        </div>
        <div class='content'>
            <div class='tag'>" . strtoupper($type) . " REQUEST</div>
            
            <div class='field'>
                <span class='label'>Full Name</span>
                <span class='value'>$name</span>
            </div>";

if ($type === 'contact') {
    $message = nl2br(filter_var($input['message'] ?? '', FILTER_SANITIZE_STRING));
    $htmlContent .= "
            <div class='field'>
                <span class='label'>Email Address</span>
                <span class='value'>$email</span>
            </div>
            <div class='field'>
                <span class='label'>Subject</span>
                <span class='value'>$subject</span>
            </div>
            <div class='field'>
                <span class='label'>Message</span>
                <span class='value'>$message</span>
            </div>";
} else {
    // Quote Details
    $phone = $input['phone'] ?? 'N/A';
    $location = $input['location'] ?? 'N/A';
    $property = $input['propertyType'] ?? 'N/A';
    $bill = $input['bill'] ?? 'N/A';
    $goal = $input['goal'] ?? 'N/A';
    $roof = $input['roof'] ?? 'N/A';
    $comments = nl2br($input['comments'] ?? 'No comments');

    $htmlContent .= "
            <div class='field'>
                <span class='label'>Phone / WhatsApp</span>
                <span class='value'>$phone</span>
            </div>
            <div class='field'>
                <span class='label'>Location</span>
                <span class='value'>$location</span>
            </div>
            <div class='field'>
                <span class='label'>Property Type</span>
                <span class='value'>$property</span>
            </div>
            <div class='field'>
                <span class='label'>Monthly Bill</span>
                <span class='value'>$bill</span>
            </div>
            <div class='field'>
                <span class='label'>Energy Goal</span>
                <span class='value'>$goal</span>
            </div>
            <div class='field'>
                <span class='label'>Roof Type</span>
                <span class='value'>$roof</span>
            </div>
            <div class='field'>
                <span class='label'>Additional Comments</span>
                <span class='value'>$comments</span>
            </div>";
}

$htmlContent .= "
        </div>
        <div class='footer'>
            <p>This message was sent from the Starlight Solar website.</p>
            <p>
                <a href='https://starlight-solar.com'>Home</a> | 
                <a href='https://starlight-solar.com/shop'>Shop</a> | 
                <a href='https://starlight-solar.com/services'>Services</a> | 
                <a href='https://starlight-solar.com/contact'>Contact</a>
            </p>
            <p style='margin-top: 20px; font-size: 11px; color: #aaa;'>&copy; 2026 Starlight Solar, LLC. Mbalgong, Yaounde, Cameroon.</p>
        </div>
    </div>
</body>
</html>";

// Headers for HTML email
$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
$headers .= "From: Starlight Solar Website <$smtpUsername>" . "\r\n";
$headers .= "Reply-To: $email" . "\r\n";

// Use mail() - in cPanel, this will work if SMTP is configured in php.ini 
// or if the server allows local mail sending which is standard.
// Given the user provided SMTP credentials, if this script is on their server,
// mail() is the standard way to trigger the server's mail handler.
if (mail($toEmail, $subject, $htmlContent, $headers)) {
    echo json_encode(["status" => "success", "message" => "Message sent successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to send message"]);
}
?>
